IF EXISTS (select * from sysobjects where name like '%T_Insert_Zona%')
DROP TRIGGER T_Insert_Zona
go

CREATE TRIGGER T_Insert_Zona
ON  Zona
FOR INSERT, UPDATE
AS
	DECLARE @IdZona DECIMAL(20,0);

	DECLARE Elems_Cursor11 CURSOR FOR
	SELECT IdZona FROM INSERTED;
	OPEN Elems_Cursor11

	FETCH NEXT FROM Elems_Cursor11 INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		PRINT 'Ejecucion trigger T_Insert_Zona. ' + CONVERT(VARCHAR(200), @IdZona);
		EXEC Procedure_AtributosDerivadosZona @IdZona;

	FETCH NEXT FROM Elems_Cursor11 INTO @IdZona
	END

	CLOSE Elems_Cursor11
	DEALLOCATE Elems_Cursor11


		---------- WebManager ----------
	DECLARE @IdZonaAux DECIMAL(20,0);
	DECLARE @Titulo NVARCHAR(100);
	DECLARE @Orden DECIMAL(10,0);
	DECLARE @RutaCompleta NVARCHAR(500);
	DECLARE @TieneServidores BIT;
	DECLARE @IdZonaPadre DECIMAL(20,0);
	DECLARE @IdCliente DECIMAL(20,0) = 1;
	DECLARE Elems_Cursor33333 CURSOR FOR
	SELECT IdZona,Titulo,Orden,TieneServidores,IdZonaPadre FROM INSERTED;
	OPEN Elems_Cursor33333
	
	FETCH NEXT FROM Elems_Cursor33333 INTO @IdZonaAux,@Titulo,@Orden,@TieneServidores,@IdZonaPadre
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'Migrar datos a tabla WM_Zona WebManager'
		PRINT 'Identificador zona: ' + CONVERT(VARCHAR(200), @IdZonaAux);
		
		IF @IdZonaAux != -1
		BEGIN
		
			select @RutaCompleta= RutaCompleta from Zona where Zona.IdZona=@IdZonaAux
				
			--En caso de que la zona tenga servidores vinculados, actualizamos a 1 el valor de TieneServidores, si no a 0
			IF (SELECT COUNT(*) FROM WM_Zona WHERE IdZona=@IdZonaAux) > 0
			BEGIN
				UPDATE WM_Zona SET Titulo=@Titulo,Orden=@Orden,RutaCompleta=@RutaCompleta,TieneServidores=@TieneServidores,IdZonaPadre=@IdZonaPadre,IdCliente=@IdCliente WHERE WM_Zona.IdZona=@IdZonaAux
			END
			ELSE
			BEGIN
				INSERT INTO WM_Zona (IdZona,Titulo,Orden,RutaCompleta,TieneServidores,IdZonaPadre,IdCliente) VALUES (@IdZonaAux,@Titulo,@Orden,@RutaCompleta,@TieneServidores,@IdZonaPadre,@IdCliente)
			END

		END
	

		PRINT 'Fin migrar datos a tabla WM_Zona WebManager'

	FETCH NEXT FROM Elems_Cursor33333 INTO @IdZonaAux,@Titulo,@Orden,@TieneServidores,@IdZonaPadre
	END
	
	CLOSE Elems_Cursor33333
	DEALLOCATE Elems_Cursor33333

	---------- Fin WebManager ----------

GO
ALTER TABLE Zona ENABLE TRIGGER T_Insert_Zona
GO